// classDataArray.java
// obiekty jako elementy struktury danych 
// uruchomienie programu: C>java ClassDataApp
////////////////////////////////////////////////////////////////
class Person
   {
   private String lastName;           // nazwisko
   private String firstName;          // imi
   private int age;                   // wiek
//--------------------------------------------------------------
   public Person(String last, String first, int a)
      {                               // konstruktor 
      lastName = last;
      firstName = first;
      age = a;
      }
//--------------------------------------------------------------
   public void displayPerson()
      {
      System.out.print("   Nazwisko: " + lastName);
      System.out.print(", Imi: " + firstName);
      System.out.println(", Wiek: " + age);
      }
//--------------------------------------------------------------
   public String getLast()           // pobierz nazwisko
      { return lastName; }
   }  // koniec klasy Person
////////////////////////////////////////////////////////////////
class ClassDataArray
   {
   private Person[] a;               // referencja do tablicy 
   private int nElems;               // liczba elementw tablicy 

   public ClassDataArray(int max)    // konstruktor 
      {
      a = new Person[max];               // tworzymy tablic 
      nElems = 0;                        // na razie brak elementw 
      }
//--------------------------------------------------------------
   public Person find(String searchName)
      {                              // wyszukiwanie rekordu
      int j;
      for(j=0; j<nElems; j++)            // dla kadego elementu...
         if( a[j].getLast().equals(searchName) )  // czy zgadza si nazwisko?
            break;                       // tak, opuszczenie ptli przed kocem
      if(j == nElems)                    // doszlimy do koca tablicy?
         return null;                    // tak, rekordu nie znaleziono 
      else
         return a[j];                    // nie, rekord znaleziony 
      }  // koniec find()
//--------------------------------------------------------------                                    // wstawienie rekordu do tablicy 
   public void insert(String last, String first, int age)
      {
      a[nElems] = new Person(last, first, age);
      nElems++;                          // zwikszamy licznik elementw 
      }
//--------------------------------------------------------------
   public boolean delete(String searchName)
      {                              // usunicie rekordu z tablicy 
      int j;
      for(j=0; j<nElems; j++)            // szukamy rekordu
         if( a[j].getLast().equals(searchName) )
            break;
      if(j==nElems)                      // rekord nieznaleziony
         return false;
      else                               // rekord znaleziony
         {
         for(int k=j; k<nElems; k++)     // przesuwamy kolejne w d
            a[k] = a[k+1];
         nElems--;                       // zmniejszamy licznik elementw 
         return true;
         }
      }  // end delete()
//--------------------------------------------------------------
   public void displayA()            // wypisuje zawarto tablicy 
      {
      for(int j=0; j<nElems; j++)       // dla kadego elementu...
         a[j].displayPerson();          // ...wypisujemy jego dane
      }
//--------------------------------------------------------------
   }  // koniec klasy ClassDataArray
////////////////////////////////////////////////////////////////
class ClassDataApp
   {
   public static void main(String[] args)
      {
      int maxSize = 100;             // rozmiar tablicy 
      ClassDataArray arr;            // referencja do tablicy 
      arr = new ClassDataArray(maxSize);  // tworzymy tablic 
                                     // wstawiamy 10 rekordw
      arr.insert("Evans", "Patty", 24);
      arr.insert("Smith", "Lorraine", 37);
      arr.insert("Yee", "Tom", 43);
      arr.insert("Adams", "Henry", 63);
      arr.insert("Hashimoto", "Sato", 21);
      arr.insert("Stimson", "Henry", 29);
      arr.insert("Velasquez", "Jose", 72);
      arr.insert("Lamarque", "Henry", 54);
      arr.insert("Vang", "Minh", 22);
      arr.insert("Creswell", "Lucinda", 18);

      arr.displayA();                // wypisujemy rekordy

      String searchKey = "Stimson";  // szukamy rekordu
      Person found;
      found=arr.find(searchKey);
      if(found != null)
         {
         System.out.print("Znaleziono ");
         found.displayPerson();
         }
      else
         System.out.println("Nie znaleziono " + searchKey);

      System.out.println("Usuwanie rekordw: Smith, Yee, Creswell");
      arr.delete("Smith");           // usuwamy 3 rekordy
      arr.delete("Yee");
      arr.delete("Creswell");

      arr.displayA();                // wypisujemy rekordy ponownie
      }  // koniec main()
   }  // koniec klasy ClassDataApp
///////////////////////////////////////////////////////////////////////
